/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.CheckEnvironmentAppletWorker;
import skeletonapplet.JreDatum;
import skeletonapplet.JreInfo;
import skeletonapplet.Utilities;

public class CheckEnvironmentDelegatorApplet2
extends AbstractDelegatorApplet {
    protected JScrollPane scrollPane;
    protected JEditorPane editorPane = new JEditorPane();

    public CheckEnvironmentDelegatorApplet2() {
        this.editorPane.setContentType("text/html");
        this.scrollPane = new JScrollPane(this.editorPane);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add(this.scrollPane);
        this.setVisible(false);
    }

    public void start() {
        super.start();
        this.editorPane.setVisible(true);
        this.editorPane.setContentType("text/html");
        if (JreInfo.soleInstance().hasErrors()) {
            this.editorPane.setText(this.getErrorHtml());
        } else {
            this.editorPane.setText(this.getInitialHtml());
            this.scrollPane.setVisible(true);
            this.setVisible(true);
            try {
                CheckEnvironmentAppletWorker checkEnvironmentAppletWorker = (CheckEnvironmentAppletWorker)this.worker;
                checkEnvironmentAppletWorker.runTests();
                String string = this.getReportHtml();
                this.editorPane.setText(string);
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
                this.editorPane.setText(this.getErrorHtml());
            }
        }
    }

    protected boolean initializationError(Throwable throwable) {
        return false;
    }

    protected boolean stopOnBrowserNameError() {
        return false;
    }

    protected boolean stopOnJarLoadingError(Throwable throwable) {
        return false;
    }

    protected boolean stopOnJreVersionError() {
        return false;
    }

    protected boolean stopOnMissingPatchFilesError(String string) {
        return false;
    }

    protected boolean stopOnNoJarFileError(String string) {
        return false;
    }

    protected boolean stopOnNoPtHomeError() {
        return false;
    }

    protected boolean stopOnNoRawFileError(String string) {
        return false;
    }

    protected boolean stopOnNoSecurityAccessError() {
        return true;
    }

    protected boolean stopOnNoWorkerError() {
        return false;
    }

    protected String getErrorHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<h1>Error</h1>\n");
        stringBuilder.append("<p>An error occurred, and the Environment Checker has no information on your system at this time.</p>\n");
        stringBuilder.append("<p>You can close all of your browsers and return to this page to try again, or visit this link at a later time.</p>\n");
        stringBuilder.append("<p>You can also make the attempt to take a Cisco Packet Tracer Skills Assessment.</p>\n");
        JreInfo jreInfo = JreInfo.soleInstance();
        List list = jreInfo.getErrors();
        for (int i = 0; i < list.size(); ++i) {
            JreDatum jreDatum = (JreDatum)list.get(i);
            this.addInformation(stringBuilder, jreDatum);
        }
        return stringBuilder.toString();
    }

    protected String getInitialHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<h1>Gathering information ...</h1>\n");
        stringBuilder.append("<p>This process may take a few minutes.</p>\n");
        stringBuilder.append("<p>When it's finished, this text will be replaced by a report on your system's readiness for Cisco Packet Tracer Skills Assessments ...</p>\n");
        return stringBuilder.toString();
    }

    protected String getReportHtml() {
        JreInfo jreInfo = JreInfo.soleInstance();
        StringBuilder stringBuilder = new StringBuilder();
        this.addInformation(stringBuilder, jreInfo.browserName());
        this.addInformation(stringBuilder, jreInfo.jreVersion());
        this.addInformation(stringBuilder, jreInfo.missingPatchFiles());
        this.addInformation(stringBuilder, jreInfo.missingPtaJarFile());
        this.addInformation(stringBuilder, jreInfo.osName());
        this.addInformation(stringBuilder, jreInfo.ptDirectory());
        this.addInformation(stringBuilder, jreInfo.ptPortsAvailable());
        this.addInformation(stringBuilder, jreInfo.ptVersion());
        this.addInformation(stringBuilder, jreInfo.securityAccess());
        return stringBuilder.toString();
    }

    protected void addInformation(StringBuilder stringBuilder, JreDatum jreDatum) {
        String string = "0.1in";
        if (jreDatum.isError() && jreDatum.hasComment()) {
            string = "0";
        }
        stringBuilder.append("<p style=\"padding-top: 0; padding-bottom: 0; margin-top: 0; margin-bottom: " + string + "\">");
        this.addInformationHeading(stringBuilder, jreDatum.getPrettyName());
        this.addInformationValue(stringBuilder, jreDatum.isUnavailable() ? "Not Available" : jreDatum.getDynamicValue());
        stringBuilder.append("</p>\n");
        if (jreDatum.isError() && jreDatum.hasComment()) {
            this.addErrorMessage(stringBuilder, jreDatum.getComment());
        }
    }

    public void addInformationHeading(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<span style=\"color: BLUE; font-weight: bold; font-size: 20\">");
        stringBuilder.append(string);
        stringBuilder.append("</span>");
    }

    public void addInformationValue(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<span style=\"color: BLACK; font-size: 16\">&nbsp;&nbsp;--&nbsp;&nbsp;");
        stringBuilder.append(string);
        stringBuilder.append("</span>");
    }

    public void addErrorMessage(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<p style=\"color: RED; font-size: 16; padding-left: 0.5in; padding-top: 0; padding-bottom: 0; margin-top: 0; margin-bottom: 0.1in\"><span style=\"font-weight: bold; font-size: 20\">ERROR</span>&nbsp;&nbsp;--&nbsp;&nbsp;");
        stringBuilder.append(string);
        stringBuilder.append("</p>\n");
    }
}

